package ru.yandex.chemodan.app.uaas.parser;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.uaas.test.UaasTestContextConfiguration;
import ru.yandex.misc.test.Assert;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {
        UaasTestContextConfiguration.class,
        UaasParserContextConfiguration.class,
})
public class UserAgentParserTest {

    @Autowired
    private UserAgentParser parser;

    @Test
    public void testParse() {
        String userAgentString = "Yandex.Disk {\"os\":\"iOS\",\"src\":\"disk.mobile\",\"vsn\":\"2.38.11378\",\"id\":\"F9F89FB5-0277-4C23-A11D-20E760A4A435\",\"device\":\"tablet\"}";
        final Option<UserAgentObject> userAgentObject = parser.parse(Option.of(userAgentString));
        Assert.notEmpty(userAgentObject);
        Assert.equals(userAgentObject.get().getVersion(), Version.of("2.38.11378"));
    }
}
