package ru.yandex.chemodan.app.uaas.parser;

import lombok.Data;
import org.jetbrains.annotations.NotNull;

@Data
public class Version implements Comparable<String> {
    private final String version;

    public static Version of(String version) {
        return new Version(version);
    }

    @Override
    public int compareTo(@NotNull String o) {
        String[] ver1 = version.split("[.-]");
        String[] ver2 = o.split("[.-]");
        for (int i = 0; i < Math.max(ver1.length, ver2.length); i++) {
            int a = 0;
            int b = 0;
            if (i < ver1.length) {
                a = Integer.parseInt(ver1[i]);
            }
            if (i < ver2.length) {
                b = Integer.parseInt(ver2[i]);
            }
            final int res = Integer.compare(a, b);
            if (res != 0) {
                return res;
            }
        }
        return 0;
    }
}
