package ru.yandex.chemodan.app.uaas.zk;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.zk.ChemodanZkPathsContextConfiguration;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

@Configuration
@Import({
        ChemodanZkPathsContextConfiguration.class,
})
public class UaasOverrideZkConfiguration {

    @Autowired
    private ZkManager zkManager;

    @Qualifier("zkAllRoot")
    @Autowired
    private ZkPath zkRoot;

    @Bean
    public UaasOverrideController uaasOverrideController(UaasOverrideZkRegistry overrideZkRegistry, UserGroupsZkRegistry groupsZkRegistry) {
        return new UaasOverrideController(overrideZkRegistry, groupsZkRegistry);
    }

    @Bean
    public UaasOverrideZkRegistry uaasOverrideZkRegistry() {
        UaasOverrideZkRegistry registry = new UaasOverrideZkRegistry(zkRoot.child("uaas").child("override"));
        zkManager.addClient(registry);
        return registry;
    }

    @Bean
    public UserGroupsZkRegistry userGroupsZkRegistry() {
        UserGroupsZkRegistry registry = new UserGroupsZkRegistry(zkRoot.child("uaas").child("groups"));
        zkManager.addClient(registry);
        return registry;
    }

    @Bean
    public ZkPingerChecker zkPingerChecker(UaasOverrideZkRegistry uaasOverrideZkRegistry) {
        return new ZkPingerChecker(uaasOverrideZkRegistry);
    }
}
