package ru.yandex.chemodan.app.uaas.zk;

import lombok.Data;

import ru.yandex.bolts.collection.SetF;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author tolmalev
 */
public class UserGroupsZkRegistry extends ZkRegistry<String, UserGroupsZkRegistry.UserGroup> {

    public UserGroupsZkRegistry(ZkPath path) {
        super(path, Bender.cons(UserGroup.class), UserGroup::getId, s -> s);
    }

    @Data
    @BenderBindAllFields
    public static class UserGroup {
        public final String id;
        public final SetF<String> uids;
        public final String description;
    }
}
