package ru.yandex.chemodan.uploader;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.lang.DefaultToString;
import ru.yandex.misc.lang.Validate;

/**
 * MPFS metadata on files stored in default chemodan storage.
 * TODO rename to DiskFileAttributes or something
 * TODO also create a similar structure UploadedDiskFileAttributes(mulcaId, contentType)
 *
 * @author vavinov
 */
public class ChemodanFile extends DefaultToString {
    @JsonProperty
    private final UidOrSpecial uidOrSpecial;
    @JsonProperty
    private final String uniqueFileId;
    @JsonProperty
    private final String path;

    public static final String FAKE_FILE_ID = "unused";
    public static final String FAKE_PATH = "unused";

    public static final ChemodanFile FAKE = new ChemodanFile(
            UidOrSpecial.uid(PassportUid.cons(1)), FAKE_FILE_ID, FAKE_PATH);

    public ChemodanFile(
            @JsonProperty("uidOrSpecial") UidOrSpecial uidOrSpecial,
            @JsonProperty("uniqueFileId") String uniqueFileId,
            @JsonProperty("path") String path)
    {
        Validate.V.notEmpty(path, "undefined path");
        this.uidOrSpecial = uidOrSpecial;
        this.uniqueFileId = uniqueFileId;
        this.path = path;
    }

    public static ChemodanFile cons(UidOrSpecial uidOrSpecial, String uniqueFileId, String path) {
        return new ChemodanFile(uidOrSpecial, uniqueFileId, path);
    }

    public static ChemodanFile consWithoutFileId(UidOrSpecial uidOrSpecial, String path) {
        return cons(uidOrSpecial, FAKE_FILE_ID, path);
    }

    public PassportUid getPassportUid() {
        return uidOrSpecial.uidO().getOrThrow("real passport uid expected").getPassportUid();
    }

    public PassportUidOrZero getPassportUidOrAnonymous() {
        return uidOrSpecial.toPassportUidOrAnonymous();
    }

    public UidOrSpecial getUidOrSpecial() {
        return uidOrSpecial;
    }

    public String getUniqueFileId() {
        return uniqueFileId;
    }

    public String getPath() {
        return path;
    }
}
