package ru.yandex.chemodan.uploader;

import java.util.Set;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.enums.EnumResolver;

/**
 * @author vavinov
 */
public enum ChemodanService {
    DISK(false),
    FOTKI(false),
    MAIL2(false),
    MULCA(false),
    DOCVIEWER(false),
    BROWSER(false),
    HANCOM(false),
    VKONTAKTE(true),
    FACEBOOK(true),
    ODNOKLASSNIKI(true),
    MAILRU(true),
    AVIARY(true),
    WEB(true),
    GOOGLE(true),
    INSTAGRAM(true),
    ONLYOFFICE(false),
    ;

    public static final EnumResolver<ChemodanService> R = EnumResolver.er(ChemodanService.class);
    private static final Set<ChemodanService> SOCIAL_NERWORKS =
            Cf.set(VKONTAKTE, FACEBOOK, ODNOKLASSNIKI, MAILRU, GOOGLE, INSTAGRAM);
    private static final Set<ChemodanService> EXPORT_ALLOWED_TO = Cf.set(VKONTAKTE, FACEBOOK, ODNOKLASSNIKI);

    private final boolean isExternal;

    ChemodanService(boolean external) {
        isExternal = external;
    }

    public boolean isExternal() {
        return isExternal;
    }

    public boolean isSocialNetwork() {
        return SOCIAL_NERWORKS.contains(this);
    }

    public static Set<ChemodanService> servicesWithExportSupport() {
        return EXPORT_ALLOWED_TO;
    }
}
