package ru.yandex.chemodan.uploader;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.commune.archive.ArchiveEntry;
import ru.yandex.misc.io.file.File2;

/**
 * @author alexm
 */
public class ExtractedFile {
    @JsonProperty
    private final ArchiveEntry entry;
    @JsonProperty
    private final File2 localFile;

    @JsonCreator
    public ExtractedFile(@JsonProperty("entry") ArchiveEntry entry, @JsonProperty("file") File2 localFile) {
        this.entry = entry;
        this.localFile = localFile;
    }
    public ArchiveEntry getEntry() {
        return entry;
    }
    public File2 getLocalFile() {
        return localFile;
    }

}
