package ru.yandex.chemodan.uploader;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.lang.DefaultObject;

@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class UidOrSpecial extends DefaultObject {
    public static class Uid extends UidOrSpecial {
        @JsonProperty
        private final PassportUid passportUid;

        @JsonCreator
        public Uid(@JsonProperty("passportUid") PassportUid passportUid) {
            this.passportUid = passportUid;
        }

        public PassportUid getPassportUid() {
            return passportUid;
        }

        public static Function<Uid, PassportUid> getPassportUidF() {
            return new Function<Uid, PassportUid>() {
                public PassportUid apply(Uid uidOrSpecial) {
                    return uidOrSpecial.getPassportUid();
                }
            };
        }

        @Override
        public Option<Uid> uidO() {
            return Option.of(this);
        }
    }

    public static class Special extends UidOrSpecial {
        @JsonProperty
        private final String special;

        @JsonCreator
        public Special(@JsonProperty("special") String special) {
            this.special = special;
        }

        public String getSpecial() {
            return special;
        }

        @Override
        public Option<Special> specialO() {
            return Option.of(this);
        }
    }

    public static Uid uid(PassportUid u) {
        return new Uid(u);
    }

    public static Special special(String special) {
        return new Special(special);
    }

    public Option<Uid> uidO() {
        return Option.empty();
    }

    public Option<Special> specialO() {
        return Option.empty();
    }

    public final PassportUidOrZero toPassportUidOrAnonymous() {
        if (uidO().isPresent()) {
            return PassportUidOrZero.fromUid(uidO().get().getPassportUid());
        } else {
            return PassportUidOrZero.zero();
        }
    }

    // XXX will this work with social auth?
    public final String toSpecialOrUidString() {
        if (uidO().isPresent()) {
            return Long.toString(uidO().get().getPassportUid().getUid());
        } else {
            return specialO().get().getSpecial();
        }
    }

    public static final String SPECIAL_DIST = "dist";
}
