package ru.yandex.chemodan.uploader;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * XXX should be done via zk, not conductor
 *
 * @author vavinov
 */
public class UploaderHosts extends DelayingWorkerServiceBeanSupport {
    private final Conductor conductor;
    private final String conductorGroup;
    private final ListF<String> defaultHosts;
    private final String slbHost;

    private volatile Option<ListF<String>> hosts = Option.empty();

    public UploaderHosts(Conductor conductor, String conductorGroup, ListF<String> defaultHosts,
            String slbHost)
    {
        this.conductor = conductor;
        this.conductorGroup = conductorGroup;
        this.defaultHosts = defaultHosts;
        this.slbHost = slbHost;
    }

    @Override
    protected Duration defaultDelay() {
        return Duration.standardMinutes(10);
    }

    @Override
    public void execute() throws Exception {
        if (StringUtils.isNotEmpty(conductorGroup)) {
            this.hosts = Option.of(conductor.getGroupHosts(conductorGroup));
        }
    }

    public ListF<String> availableHosts() {
        return this.hosts.getOrElse(defaultHosts);
    }

    public String getSlbHost() {
        return slbHost;
    }
}
