package ru.yandex.chemodan.uploader;

import java.util.Properties;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.uploader.config.UploaderAdminContextConfiguration;
import ru.yandex.chemodan.uploader.config.UploaderControlDaemonContextConfiguration;
import ru.yandex.chemodan.uploader.config.UploaderCoreContextConfiguration;
import ru.yandex.chemodan.uploader.config.UploaderDataDaemonContextConfiguration;
import ru.yandex.chemodan.uploader.config.UploaderDataWorkerContextConfiguration;
import ru.yandex.chemodan.uploader.log.UploaderLog4jHelper;
import ru.yandex.chemodan.uploader.registry.record.status.MpfsRequestStatus;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvm2ContextConfiguration;
import ru.yandex.commune.uploader.local.queue.LocalQueueProcessor;
import ru.yandex.commune.uploader.local.queue.LocalRequestQueue;
import ru.yandex.commune.uploader.registry.StageProperties;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

public class UploaderMain extends ChemodanMainSupport {

    public static void main(String[] args) throws Exception {
        new UploaderMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "uploader");
    }

    @Override
    public void initializeAppSpecific() throws Exception {
        super.initializeAppSpecific();
        applicationContext.getBean(LocalRequestQueue.class).setEnabled(true);
        applicationContext.getBean(LocalRequestQueue.class).start();
        applicationContext.getBean(LocalQueueProcessor.class).setEnabled(true);
        applicationContext.getBean(LocalQueueProcessor.class).start();
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                UploaderCoreContextConfiguration.class,
                UploaderControlDaemonContextConfiguration.class,
                UploaderDataDaemonContextConfiguration.class,
                UploaderDataWorkerContextConfiguration.class,
                UploaderAdminContextConfiguration.class,
                ZkTvm2ContextConfiguration.class
                );
    }

    @Override
    public final Tuple2<Properties, String[]> loadProperties(String[] args) {
        Tuple2<Properties, String[]> r = super.loadProperties(args);

        MpfsRequestStatus.registerStatuses();
        // validation should be done at any time between MRS.registerStatuses and services start
        StageProperties.validate(r._1);

        return r;
    }

    @Override
    protected void configureLogger() {
        AppName appName = applicationName();

        UploaderLog4jHelper.rootLoggerBuilder().appName(appName).build();
        UploaderLog4jHelper.accessLoggerBuilder().tskvOnly(false).appName(appName).build();

        UploaderLog4jHelper.configureEventsLogger(appName);
        UploaderLog4jHelper.configureStatLogger(appName);
        UploaderLog4jHelper.configureAntifoLogger(appName);
        UploaderLog4jHelper.configureExifLogger(appName);
        UploaderLog4jHelper.configureUploaderExLogging();
    }
}
