package ru.yandex.chemodan.uploader.admin;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.XmlRootElement;

/**
 * @author nshmakov
 */
@ActionContainer
public class DevicesNamesZScript {

    @Autowired
    @Qualifier("diskDeviceName")
    private String diskDeviceName;
    @Autowired
    @Qualifier("networkInterfaceName")
    private String networkInterfaceName;
    @Autowired
    @Qualifier("deviceSectorSize")
    private Integer deviceSectorSize;

    @ZAction(defaultAction = true)
    @Path("/devices-names")
    public DevicesNames index() {
        return new DevicesNames(networkInterfaceName, diskDeviceName, deviceSectorSize);
    }

    @Bendable
    @XmlRootElement(name = "content")
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class DevicesNames {

        public final String diskDeviceName;
        public final String networkInterfaceName;
        public final Integer deviceSectorSize;

        public DevicesNames(String networkInterfaceName, String diskDeviceName, Integer deviceSectorSize) {
            this.networkInterfaceName = networkInterfaceName;
            this.diskDeviceName = diskDeviceName;
            this.deviceSectorSize = deviceSectorSize;
        }
    }
}
