package ru.yandex.chemodan.uploader.av;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.env.Environment;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
@RequiredArgsConstructor
public abstract class BaseAntivirus {
    private static final Logger logger = LoggerFactory.getLogger(BaseAntivirus.class);

    private final boolean enabled;
    private final DataSize maxFileSize;
    private final boolean supportFileOnly;

    public boolean isEnabled() {
        return !Environment.isDeveloperNotebook() && enabled;
    }

    public boolean supportFileOnly() {
        return supportFileOnly;
    }

    public DataSize getMaxFileSize() {
        return maxFileSize;
    }

    public boolean isEnabledForFileSize(Option<DataSize> sizeO) {
        if (!sizeO.isPresent()) {
            logger.warn("File size is unknown -- ignoring dr.web.max.file.size");
            return true;
        } else if (sizeO.get().compareTo(getMaxFileSize()) > 0) {
            logger.info("Won't check file of size {} > {}",
                    sizeO.get().toStringShort(), getMaxFileSize().toStringShort());
            return false;
        } else {
            return true;
        }
    }

    public AntivirusResult check(InputStreamSource file) {
        if (!isEnabled()) {
            return AntivirusResult.UNKNOWN;
        }
        Validate.isTrue(!supportFileOnly() || file instanceof File2, "File only mode enabled!");

        Option<DataSize> sizeO = file.lengthO().map(DataSize::fromBytes);
        if (!isEnabledForFileSize(sizeO)) {
            return AntivirusResult.UNKNOWN;
        }

        return doCheck(file);
    }

    protected abstract AntivirusResult doCheck(InputStreamSource file);
}
