package ru.yandex.chemodan.uploader.av;

import ru.yandex.chemodan.util.HostBasedSwitch;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class DoubleAntivirus extends BaseAntivirus {

    private static final Logger log = LoggerFactory.getLogger(DoubleAntivirus.class);

    private final HostBasedSwitch secondaryEnabled = new HostBasedSwitch("secondary-antivirus-enabled-for-hosts");
    private final HostBasedSwitch primaryDisabled = new HostBasedSwitch("primary-antivirus-disabled-for-hosts");
    private final DynamicProperty<Boolean> ignoreSecondaryResult = new DynamicProperty<>("ignore-secondary-antivirus-result", true);
    private final BaseAntivirus primary;
    private final BaseAntivirus secondary;

    public DoubleAntivirus(boolean enabled, DataSize maxFileSize, boolean supportFileOnly, BaseAntivirus primary, BaseAntivirus secondary) {
        super(enabled, maxFileSize, supportFileOnly);
        this.primary = primary;
        this.secondary = secondary;
    }

    private AntivirusResult check(boolean usePrimary, InputStreamSource file) {
        BaseAntivirus antivirus = usePrimary ? primary : secondary;
        String name = usePrimary ? "primary" : "secondary";
        long start = System.currentTimeMillis();
        try {
            AntivirusResult result = antivirus.doCheck(file);
            log.info(String.format("%s antivirus result is %s", name, result));
            return result;
        } catch (Exception e) {
            if (!usePrimary && !primaryDisabled.get() && ignoreSecondaryResult.get()) {
                log.warn(String.format("call to %s antivirus failed (ignored)", name), e);
                log.info(String.format("%s antivirus result is %s", name, AntivirusResult.UNKNOWN));
                return AntivirusResult.UNKNOWN;
            } else {
                throw ExceptionUtils.translate(e);
            }
        } finally {
            log.info(String.format("running %s antivirus took %s ms", name, System.currentTimeMillis() - start));
        }
    }

    @Override
    protected AntivirusResult doCheck(InputStreamSource file) {
        if (secondaryEnabled.get()) {
            AntivirusResult p = AntivirusResult.UNKNOWN;
            if (!primaryDisabled.get()) {
                p = check(true, file);
            }
            AntivirusResult s = check(false, file);
            if (!primaryDisabled.get() && ignoreSecondaryResult.get()) {
                return p;
            } else if (primaryDisabled.get()) {
                return s;
            } else {
                if (p == AntivirusResult.INFECTED || s == AntivirusResult.INFECTED) {
                    return AntivirusResult.INFECTED;
                }
                if (p == AntivirusResult.HEALTHY || s == AntivirusResult.HEALTHY) {
                    return AntivirusResult.HEALTHY;
                }
                return AntivirusResult.UNKNOWN;
            }
        } else {
            return primary.doCheck(file);
        }
    }
}
