package ru.yandex.chemodan.uploader.av.drweb;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author vavinov
 */
public class ShellAntivirusMain extends ChemodanMainSupport {
    public static void main(String[] args) {
        new ShellAntivirusMain().runMain(args);
    }

    @Override
    protected void run() throws Exception {
        System.out.println(
                applicationContext.getBean(ShellAntivirus.class).check(new File2(unusedArgs[0])));
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("chemodan", "antivirus-main");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list();
    }

    @Override
    protected void configureLogger() {
        Log4jHelper.rootLoggerBuilder().appName(applicationName()).build();
    }

    @Override
    protected boolean isDaemon() {
        return false;
    }
}
