package ru.yandex.chemodan.uploader.av.icap;

import java.io.IOException;

import ru.yandex.chemodan.uploader.av.AntivirusResult;
import ru.yandex.chemodan.uploader.av.BaseAntivirus;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.IoUtils;

/**
 * @author akirakozov
 */
public class IcapFileScanner extends BaseAntivirus {

    private final String icapService;
    private final String host;
    private final int port;
    private final IcapServiceTimeoutConfiguration timeoutConfiguration;

    public IcapFileScanner(
            String host, int port, String icapService,
            boolean enabled, DataSize maxFileSize, boolean supportFileOnly,
            IcapServiceTimeoutConfiguration timeoutConfiguration)
    {
        super(enabled, maxFileSize, supportFileOnly);
        this.host = host;
        this.port = port;
        this.icapService = icapService;
        this.timeoutConfiguration = timeoutConfiguration;
    }

    @Override
    protected AntivirusResult doCheck(InputStreamSource source) {
        try (IcapClient client = new IcapClient(host, port, icapService,
                timeoutConfiguration.toClientConfiguration())) {
            return client.scanFile(source);
        } catch (IOException e) {
            throw IoUtils.translate(e);
        }
    }

}
