package ru.yandex.chemodan.uploader.av.icap;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class IcapResponseInputStreamProvider implements IcapResponseProvider {

    private static final Logger logger = LoggerFactory.getLogger(IcapResponseInputStreamProvider.class);

    private final InputStream inputStream;

    private final int chunkSize;

    private boolean endHasBeenReached = false;

    public IcapResponseInputStreamProvider(InputStream inputStream, int chunkSize) {
        this.inputStream = inputStream;
        this.chunkSize = chunkSize;
    }

    @Override
    public String nextResponsePart() {
        try {
            byte[] buffer = new byte[chunkSize];
            int n = inputStream.read(buffer, 0, buffer.length);
            if (n == -1) {
                endHasBeenReached = true;
                return "";
            }
            return new String(buffer, 0, n, StandardCharsets.UTF_8);
        } catch (IOException e) {
            logger.warn("Caught exception during reading from stream", e);
            endHasBeenReached = true;
        }
        return "";
    }

    @Override
    public boolean endHasBeenReached() {
        return endHasBeenReached;
    }
}
