package ru.yandex.chemodan.uploader.av.icap;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class IcapResponseParser {
    private static final String CRLF = "\r\n";
    private static final String TERMINATOR = "\r\n\r\n";
    private static final String HTTP_STATUS_LINE_PREFIX = "HTTP/";

    public int parseIcapStatusCode(String response) {
        try {
            String statusLine = StringUtils.substringBefore(response, CRLF);
            return Integer.parseInt(statusLine.split(" ")[1]);
        } catch (Exception e) {
            throw new IcapException("Couldn't parse icap status code: " + response, e);
        }
    }

    public Option<Integer> parseHttpStatusCode(String response) {
        try {
            String encapsulatedHttpResponse = StringUtils.substringAfter(response, TERMINATOR);
            String httpStatusLine = StringUtils.substringBefore(encapsulatedHttpResponse, CRLF);
            if (StringUtils.startsWith(httpStatusLine, HTTP_STATUS_LINE_PREFIX)) {
                return Option.of(Integer.parseInt(httpStatusLine.split(" ")[1]));
            } else {
                return Option.empty();
            }
        } catch (Exception e) {
            throw new IcapException("Couldn't parse icap status code: " + response, e);
        }
    }

    public Option<String> parseBlockReason(String response) {
        try {
            String encapsulatedHttpResponse = StringUtils.substringAfter(response, TERMINATOR);
            String httpBody = StringUtils.substringAfter(encapsulatedHttpResponse, TERMINATOR);
            String[] parts = httpBody.split(CRLF);
            if (parts.length > 2) {
                return Option.of(parts[1]);
            } else {
                return Option.empty();
            }
        } catch (Exception e) {
            throw new IcapException("Couldn't parse encapsulated http body: " + response, e);
        }
    }

}
