package ru.yandex.chemodan.uploader.av.icap;

import ru.yandex.commune.dynproperties.DynamicProperty;

public class IcapServiceTimeoutConfiguration {

    private static final String CONNECT_TIMEOUT_PARAMETER_NAME_TEMPLATE = "disk-uploader-antivirus-%s-connect-timeout-ms";

    private static final String READ_TIMEOUT_PARAMETER_NAME_TEMPLATE = "disk-uploader-antivirus-%s-read-timeout-ms";

    private static final String WRITE_TIMEOUT_PARAMETER_NAME_TEMPLATE = "disk-uploader-antivirus-%s-write-timeout-ms";

    private static final String READ_CHUNK_SIZE_PARAMETER_NAME_TEMPLATE = "disk-uploader-antivirus-%s-read-chunk-size";

    private final DynamicProperty<Integer> connectTimeout;

    private final DynamicProperty<Integer> readTimeout;

    private final DynamicProperty<Integer> writeTimeout;

    private final DynamicProperty<Integer> readChunkSize;

    public IcapServiceTimeoutConfiguration(String antivirusName) {
        connectTimeout = new DynamicProperty<>(String.format(CONNECT_TIMEOUT_PARAMETER_NAME_TEMPLATE, antivirusName), 500);
        readTimeout = new DynamicProperty<>(String.format(READ_TIMEOUT_PARAMETER_NAME_TEMPLATE, antivirusName), 5000);
        writeTimeout = new DynamicProperty<>(String.format(WRITE_TIMEOUT_PARAMETER_NAME_TEMPLATE, antivirusName), 20000);
        readChunkSize = new DynamicProperty<>(String.format(READ_CHUNK_SIZE_PARAMETER_NAME_TEMPLATE, antivirusName), 65536);
    }

    public IcapClientConfiguration toClientConfiguration() {
        return new IcapClientConfiguration(connectTimeout.get(), readTimeout.get(), writeTimeout.get(), readChunkSize.get());
    }
}
