package ru.yandex.chemodan.uploader.browser;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.inside.mds.MdsActions;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.inside.mds.MdsUrlUtils;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4InputStreamSource;
import ru.yandex.misc.ip.HostPort;

/**
 * @author akirakozov
 */
public class BrowserApiMdsClient {
    private final HostPort hostPort;
    private final String namespace;
    private final HttpClient httpClient;

    public BrowserApiMdsClient(HostPort hostPort, String namespace, HttpClient httpClient) {
        this.hostPort = hostPort;
        this.namespace = namespace;
        this.httpClient = httpClient;
    }

    public InputStreamSource download(MdsFileKey fileKey) {
        return new ApacheHttpClient4InputStreamSource(httpClient, new HttpGet(getDownloadUrl(fileKey)));
    }

    private String getDownloadUrl(MdsFileKey fileKey) {
        return MdsUrlUtils.actionUrl(hostPort, MdsActions.GET, namespace, fileKey);
    }
}
