package ru.yandex.chemodan.uploader.browser;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.misc.ip.HostPort;

/**
 * @author akirakozov
 */
@Configuration
public class BrowserMdsContextConfiguration {
    @Bean
    public BrowserApiMdsClient browserApiMdsClient(
            @Value("${uploader.mds.host}") String host,
            @Value("${uploader.mds.browser.namespace}") String namespace)
    {
        return new BrowserApiMdsClient(new HostPort(host, 80), namespace, browserMdsHttpClientConfigurator().configure());
    }

    @Bean
    @OverridableValuePrefix("browser_mds")
    public HttpClientConfigurator browserMdsHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
