package ru.yandex.chemodan.uploader.browser;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mds.Mds;
import ru.yandex.inside.mds.MdsMetrics;
import ru.yandex.inside.mds.MdsNamespace;
import ru.yandex.misc.io.http.Timeout;

/**
 * @author akirakozov
 */
@ContextConfiguration
public class BrowserMdsTestContextConfiguration {
    private static int READ_PORT = 80;
    private static int WRITE_PORT = 1111;

    @Bean
    public Mds browserMds(
            @Value("${uploader.mds.host}") String host,
            @Value("${uploader.mds.browser.namespace}") String namespace,
            @Value("${uploader.mds.browser.namespace.write.auth-header}") String authHeader,
            @Value("${uploader.mds.socket.timeout}") Duration soTimeout,
            @Value("${uploader.mds.connection.timeout}") Duration connTimeout,
            @Value("${uploader.mds.max.connections}") int maxConnections)
    {
        MdsNamespace mdsNamespace = new MdsNamespace(namespace, authHeader, Option.empty());
        return new Mds(host, READ_PORT, WRITE_PORT, mdsNamespace, maxConnections,
                new Timeout(soTimeout.getMillis(), connTimeout.getMillis()), MdsMetrics.EMPTY);
    }
}
