package ru.yandex.chemodan.uploader.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.uploader.preview.AlbumPreviewManager;
import ru.yandex.chemodan.uploader.preview.FoggingManager;
import ru.yandex.chemodan.uploader.preview.ImageMagickPathHelper;
import ru.yandex.chemodan.uploader.preview.LogoManager;
import ru.yandex.chemodan.uploader.preview.SizeExtractor;
import ru.yandex.chemodan.uploader.preview.annotations.AlbumAnnotationManager;
import ru.yandex.chemodan.uploader.preview.annotations.AnnotationFileGenerator;
import ru.yandex.misc.io.file.File2;

/**
 * @author metal
 */
@Configuration
public class ImageAnnotationContextConfiguration {
    @Bean
    public ImageMagickPathHelper imageMagickPathHelper() {
        return new ImageMagickPathHelper();
    }

    @Bean
    public LogoManager logoManager(@Value("${disk.logo.file}") File2 logoFile) {
        return new LogoManager(logoFile);
    }

    @Bean
    public SizeExtractor sizeExtractor(ImageMagickPathHelper pathHelper) {
        return new SizeExtractor(pathHelper);
    }

    @Bean
    public FoggingManager foggingManager() {
        return new FoggingManager();
    }

    @Bean
    public AnnotationFileGenerator annotationFileGenerator() {
        return new AnnotationFileGenerator();
    }

    @Bean
    public AlbumAnnotationManager albumAnnotationManager() {
        return new AlbumAnnotationManager();
    }

    @Bean
    public AlbumPreviewManager albumPreviewManager() {
        return new AlbumPreviewManager();
    }
}
