package ru.yandex.chemodan.uploader.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.uploader.social.ExternalResourceClient;
import ru.yandex.chemodan.uploader.social.ExternalResourceClientImpl;
import ru.yandex.chemodan.util.http.zora.ZoraConfiguration;
import ru.yandex.chemodan.util.http.zora.ZoraContextConfiguration;
import ru.yandex.chemodan.util.http.zora.ZoraHeader;

/**
 * @author nshmakov
 */
@Configuration
@Import({
        ZoraContextConfiguration.class,
})
public class SocialNetworksContextConfiguration {

    @Bean
    public ZoraConfiguration zoraConfiguration() {
        return new ZoraConfiguration(Cf.list(new ZoraHeader.IgnorCerts(true)));
    }

    @Bean
    public ExternalResourceClient externalResourceClient() {
        return new ExternalResourceClientImpl();
    }
}
