package ru.yandex.chemodan.uploader.config;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.uploader.admin.DevicesNamesZScript;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;

/**
 * @author nshmakov
 */
@Configuration
@Import({
        ZkAdminContextConfiguration.class,
})
public class UploaderAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;

    @Bean
    public DevicesNamesZScript devicesNamesZScript() {
        return new DevicesNamesZScript();
    }

    @PostConstruct
    public void configure() {
        adminApp.registerAdminPage("Devices", devicesNamesZScript());
    }
}
