package ru.yandex.chemodan.uploader.config;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.http.DiskJetty;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.chemodan.uploader.UploaderPorts;
import ru.yandex.chemodan.uploader.web.ApiPrivateUrls;
import ru.yandex.chemodan.uploader.web.ApiUrls;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;
import ru.yandex.misc.web.servletContainer.jetty.MuteErrorHandler;

/**
 * @author vavinov
 */
@Configuration
public class UploaderControlDaemonContextConfiguration {
    @Bean
    @Qualifier("controlJetty")
    public SingleWarJetty controlJetty(
            @Value("${http.maxThreads}")     int maxThreads,
            @Value("${http.maxQueueLength}") int maxQueueLength,
            @Value("${control.socket.maxIdleTime}") Duration maxIdleTime,
            UploaderPorts uploaderHttpPorts,
            UploaderCoreContextConfiguration servlets)
    {
        DiskJetty jetty = new DiskJetty("kld");
        jetty.setHttpPort(uploaderHttpPorts.getControlPort());
        jetty.setMaxThreads(maxThreads);
        jetty.setMaxQueueLength(maxQueueLength);
        jetty.setCopyBeanPostprocessors(true);
        jetty.setLookupServletsInContext(false);
        jetty.setRequestLogFactory(DiskLog4jRequestLog.consF());
        jetty.setMaxIdleTimeMillis((int) maxIdleTime.getMillis());
        jetty.addServletMapping(ApiUrls.PING, servlets.pingControlDaemonServlet());
        jetty.addServletMapping(ApiUrls.PUBLISH + "/*", servlets.publishServlet());
        jetty.addServletMapping(ApiUrls.QUEUE_STATUS + "/*", servlets.queueStatusServlet());
        jetty.addServletMapping(ApiUrls.PATCH_URL + "/*", servlets.uploadDeltaUrlServlet());
        jetty.addServletMapping(ApiUrls.LIST_ARCHIVE_URL + "/*", servlets.listArchiveServlet());
        jetty.addServletMapping(ApiUrls.EXTRACT_ARCHIVE_URL + "/*", servlets.extractArchiveServlet());
        jetty.addServletMapping(ApiUrls.EXTRACT_FILE_FROM_ARCHIVE_URL + "/*", servlets.extractFileFromArchiveServlet());
        jetty.addServletMapping(ApiUrls.CONVERT_TO_MS_OOXML_FORMAT + "/*", servlets.convertToMsOoxmlFormatServlet());
        jetty.addServletMapping(ApiUrls.GENERATE_PREVIEW_URL + "/*", servlets.generatePreviewServlet());
        jetty.addServletMapping(ApiUrls.GENERATE_ALBUM_PREVIEW_URL + "/*", servlets.generateAlbumPreviewServlet());
        jetty.addServletMapping(ApiUrls.REGENERATE_PREVIEW_URL + "/*", servlets.regeneratePreviewServlet());
        jetty.addServletMapping(ApiUrls.REGENERATE_EXIF_URL + "/*", servlets.regenerateExifServlet());
        jetty.addServletMapping(ApiUrls.RECHECK_VIRUSES_URL + "/*", servlets.recheckViruses());
        jetty.addServletMapping(ApiUrls.RECALC_DIGESTS_URL + "/*", servlets.recalcDigestsServlet());
        jetty.addServletMapping(ApiUrls.EXPORT_PHOTOS_URL + "/*", servlets.exportPhotosServlet());
        jetty.addServletMapping(ApiUrls.ZIP_FOLDER_URL + "/*", servlets.zipFolderServlet());
        jetty.addServletMapping(ApiUrls.ZIP_FILES_URL + "/*", servlets.zipFilesServlet());
        jetty.addServletMapping(ApiUrls.ZIP_FOLDER_PUBLIC_URL + "/*", servlets.zipFolderServletPublic());
        jetty.addServletMapping(ApiUrls.ZIP_ALBUM_URL + "/*", servlets.zipAlbumServlet());
        jetty.addServletMapping(ApiUrls.UPLOAD_FROM_SERVICE + "/*", servlets.uploadFromServiceServlet());
        jetty.addServletMapping(ApiUrls.UPLOAD_TO_SERVICE_URL + "/*", servlets.uploadToServiceUrlServlet());
        jetty.addServletMapping(ApiUrls.UPLOAD_URL + "/*", servlets.uploadUrlServlet());
        jetty.addServletMapping(ApiUrls.EXTRACT_ROTATION + "/*", servlets.extractRotationServlet());
        jetty.addServletMapping(ApiUrls.LOADING_STATUS + "/*", servlets.loadingStatusServlet());
        jetty.addServletMapping(ApiUrls.PATCH_INSTALLER + "/*", servlets.patchInstallerServlet());
        jetty.addServletMapping(ApiPrivateUrls.REQUEST_STATUS + "/*", servlets.requestStatusServlet());
        jetty.addServletMapping("/help/*", servlets.helpServlet());
        jetty.initialize();
        jetty.getContainerRootContext().setErrorHandler(new MuteErrorHandler());
        return jetty;
    }
}
