package ru.yandex.chemodan.uploader.config;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.UnaryOperator;

import javax.servlet.http.HttpServlet;

import org.apache.http.client.HttpClient;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.boot.ChemodanInitContextConfiguration;
import ru.yandex.chemodan.boot.admin.ChemodanAdminDaemonContextConfiguration;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.mime.LibMagicMimeTypeDetector;
import ru.yandex.chemodan.mime.MimeTypeCorrector;
import ru.yandex.chemodan.mpfs.MpfsClientContextConfiguration;
import ru.yandex.chemodan.mpfs.MpfsManager;
import ru.yandex.chemodan.mulca.MulcaClientContextConfiguration;
import ru.yandex.chemodan.mulca.MulcaUploadManager;
import ru.yandex.chemodan.uploader.UploaderHosts;
import ru.yandex.chemodan.uploader.UploaderPorts;
import ru.yandex.chemodan.uploader.av.BaseAntivirus;
import ru.yandex.chemodan.uploader.av.DoubleAntivirus;
import ru.yandex.chemodan.uploader.av.drweb.ShellAntivirus;
import ru.yandex.chemodan.uploader.av.icap.IcapFileScanner;
import ru.yandex.chemodan.uploader.av.icap.IcapServiceTimeoutConfiguration;
import ru.yandex.chemodan.uploader.docviewer.DocviewerContextConfiguration;
import ru.yandex.chemodan.uploader.local.queue.LocalQueueSensors;
import ru.yandex.chemodan.uploader.mime.FfprobeMimeTypeCorrector;
import ru.yandex.chemodan.uploader.mulca.MulcaAndAvatarsClient;
import ru.yandex.chemodan.uploader.mulca.SimultaneousMulcaUploadManager;
import ru.yandex.chemodan.uploader.office.OfficeUploadManager;
import ru.yandex.chemodan.uploader.preview.Dcraw;
import ru.yandex.chemodan.uploader.preview.HeifConverter;
import ru.yandex.chemodan.uploader.preview.PreviewImageManager;
import ru.yandex.chemodan.uploader.processor.SyncRequestProcessor;
import ru.yandex.chemodan.uploader.registry.ChemodanRequestDirector;
import ru.yandex.chemodan.uploader.registry.QueueSensors;
import ru.yandex.chemodan.uploader.registry.RequestStatesHandler;
import ru.yandex.chemodan.uploader.registry.StageListenerPoolWithChildren;
import ru.yandex.chemodan.uploader.registry.Stages;
import ru.yandex.chemodan.uploader.registry.ZipFolderStages;
import ru.yandex.chemodan.uploader.registry.processors.ProcessorsContextConfiguration;
import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.chemodan.uploader.registry.record.Record;
import ru.yandex.chemodan.uploader.services.ServiceApisContextConfiguration;
import ru.yandex.chemodan.uploader.social.ExternalResourceSemaphores;
import ru.yandex.chemodan.uploader.social.ExternalResourceSensors;
import ru.yandex.chemodan.uploader.stage.LoggableStageProcessor;
import ru.yandex.chemodan.uploader.stage.StageProcessor;
import ru.yandex.chemodan.uploader.status.LoadingStatusManager;
import ru.yandex.chemodan.uploader.status.LogsFreeSizeChecker;
import ru.yandex.chemodan.uploader.status.MaintenanceFileChecker;
import ru.yandex.chemodan.uploader.status.strategy.DiskIoBasedStrategy;
import ru.yandex.chemodan.uploader.status.strategy.DiskIopsBasedStrategy;
import ru.yandex.chemodan.uploader.status.strategy.ExponentialUserQueueInProgressLoadingStatusStrategy;
import ru.yandex.chemodan.uploader.status.strategy.ExponentialUserQueueInitialLoadingStatusStrategy;
import ru.yandex.chemodan.uploader.status.strategy.LaBasedStrategy;
import ru.yandex.chemodan.uploader.status.strategy.LoadingStatusStrategy;
import ru.yandex.chemodan.uploader.status.strategy.MulcaQueueSizeLoadingStatusStrategy;
import ru.yandex.chemodan.uploader.status.strategy.NetworkIoBasedStrategy;
import ru.yandex.chemodan.uploader.status.strategy.NetworkIoLoadingStatusDelayHolder;
import ru.yandex.chemodan.uploader.status.strategy.UserQueueSizeLoadingStatusStrategy;
import ru.yandex.chemodan.uploader.status.strategy.utils.DiskDeviceLinuxUtils;
import ru.yandex.chemodan.uploader.status.strategy.utils.NetworkInterfaceLinuxUtils;
import ru.yandex.chemodan.uploader.web.UploadTimeoutHolder;
import ru.yandex.chemodan.uploader.web.control.BannedDomainProxySettingsImpl;
import ru.yandex.chemodan.uploader.web.control.BannedDomainsProxySettings;
import ru.yandex.chemodan.uploader.web.control.ControlResponseXmlizer;
import ru.yandex.chemodan.uploader.web.control.ConvertToMsOoxmlFormatServlet;
import ru.yandex.chemodan.uploader.web.control.ExportPhotosServlet;
import ru.yandex.chemodan.uploader.web.control.ExtractArchiveServlet;
import ru.yandex.chemodan.uploader.web.control.ExtractFileFromArchiveServlet;
import ru.yandex.chemodan.uploader.web.control.ExtractRotationServlet;
import ru.yandex.chemodan.uploader.web.control.HelpServlet;
import ru.yandex.chemodan.uploader.web.control.ListArchiveServlet;
import ru.yandex.chemodan.uploader.web.control.LoadingStatusServlet;
import ru.yandex.chemodan.uploader.web.control.PingDiskServlet;
import ru.yandex.chemodan.uploader.web.control.PublishServlet;
import ru.yandex.chemodan.uploader.web.control.QueueStatusServlet;
import ru.yandex.chemodan.uploader.web.control.RegeneratePreviewServlet;
import ru.yandex.chemodan.uploader.web.control.RequestStatusServlet;
import ru.yandex.chemodan.uploader.web.control.UploadDeltaUrlServlet;
import ru.yandex.chemodan.uploader.web.control.UploadFromServiceServlet;
import ru.yandex.chemodan.uploader.web.control.UploadToServiceUrlServlet;
import ru.yandex.chemodan.uploader.web.control.UploadUrlServlet;
import ru.yandex.chemodan.uploader.web.control.ZipFolderServlet;
import ru.yandex.chemodan.uploader.web.control.ZipFolderServlet.Type;
import ru.yandex.chemodan.uploader.web.control.sync.GenerateAlbumPreviewSyncRequest;
import ru.yandex.chemodan.uploader.web.control.sync.GeneratePreviewSyncRequest;
import ru.yandex.chemodan.uploader.web.control.sync.PatchInstallerServlet;
import ru.yandex.chemodan.uploader.web.control.sync.RecalcDigestsServlet;
import ru.yandex.chemodan.uploader.web.control.sync.RecheckVirusesServlet;
import ru.yandex.chemodan.uploader.web.control.sync.RegenerateExifServlet;
import ru.yandex.chemodan.uploader.web.data.CrossdomainXmlServlet;
import ru.yandex.chemodan.uploader.web.data.RobotsTxtServlet;
import ru.yandex.chemodan.uploader.web.data.util.UserUploadSpeedLimitManager;
import ru.yandex.chemodan.util.BleedingEdge;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.oauth.OauthClient;
import ru.yandex.commune.alive2.location.Location;
import ru.yandex.commune.archive.ArchiveManager;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.commune.uploader.local.file.LocalFileManager;
import ru.yandex.commune.uploader.local.queue.LocalQueueProcessor;
import ru.yandex.commune.uploader.local.queue.LocalQueuePush;
import ru.yandex.commune.uploader.local.queue.LocalRequestQueue;
import ru.yandex.commune.uploader.registry.StageListenerPool;
import ru.yandex.commune.uploader.registry.StageProperties;
import ru.yandex.commune.uploader.registry.StageSemaphores;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.commune.uploader.registry.storage.DiskRecordStorage;
import ru.yandex.commune.uploader.registry.storage.DiskRecordStorageGc;
import ru.yandex.commune.uploader.registry.storage.IoQueue;
import ru.yandex.commune.uploader.web.data.DiskWritePolicy;
import ru.yandex.commune.video.FfTools;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.ConductorContextConfiguration;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.mime.detect.MimeTypeDetector;
import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.os.CpuBound;
import ru.yandex.misc.parse.CommaSeparated;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.version.AppName;

/**
 * @author vavinov
 */
@Configuration
@Import({
        ChemodanAdminDaemonContextConfiguration.class,
        ChemodanInitContextConfiguration.class,
        ConductorContextConfiguration.class,
        SocialNetworksContextConfiguration.class,
        ProcessorsContextConfiguration.class,
        DocviewerContextConfiguration.class,
        ImageAnnotationContextConfiguration.class,
        MpfsClientContextConfiguration.class,
        MulcaClientContextConfiguration.class,
        Tvm2BaseContextConfiguration.class,
        ServiceApisContextConfiguration.class
})
public class UploaderCoreContextConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(UploaderCoreContextConfiguration.class);

    @Value("${uploader.hosts.conductor.group}")
    private String conductorGroup;
    @Value("${uploader.hosts.default.csv}")
    private String defaultHosts;
    @Value("${uploader.slb.host}")
    private String slbHost;
    @Value("${loadingStatus.disk.device}")
    private String diskDeviceOverride;
    @Value("${loadingStatus.network.interface:-}")
    private String networkInterfaceOverride;
    @Value("${loadingStatus.disk.deviceSectorSize:-}")
    private String deviceSectorSizeOverride;
    @Value("${app.spool.dir}")
    private String spoolDir;

    @MulcaClientContextConfiguration.Mulca
    @Bean
    public UnaryOperator<MulcaClient> mulcaClientInterceptor(
            @Value("${avatars.download.host}") String avatarsDownloadHost,
            @Value("${avatars.upload.host}") String avatarsUploadHost
    ) {
        return client -> new MulcaAndAvatarsClient(client, avatarsUploadHost, avatarsDownloadHost);
    }

    @Bean
    @Qualifier("experimental")
    public BleedingEdge experimentalBleedingEdge() {
        return new BleedingEdge("uploader-experimental");
    }

    @Bean
    @Qualifier("simultaneousMulcaUpload")
    public BleedingEdge simultaneousMulcaUploadBleedingEdge() {
        return new BleedingEdge("uploader-simultaneous-mulca-upload");
    }

    @Bean
    public HttpClient mulcaHttpClientForZipFolder() {
        return mulcaForZipHttpClientConfigurator().configure();
    }

    @Bean
    @OverridableValuePrefix("mulca_for_zip")
    public HttpClientConfigurator mulcaForZipHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    @Qualifier("avatars")
    @OverridableValuePrefix("avatars")
    public HttpClientConfigurator avatarsHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public MpfsManager mpfsManager() {
        return new MpfsManager();
    }

    @Bean
    public IcapServiceTimeoutConfiguration primaryAntivirusTimeoutConfiguration() {
        return new IcapServiceTimeoutConfiguration("primary");
    }

    @Bean
    public IcapServiceTimeoutConfiguration secondaryAntivirusTimeoutConfiguration() {
        return new IcapServiceTimeoutConfiguration("secondary");
    }

    @Bean
    public BaseAntivirus antivirus(
            @Value("${antivirus.enabled}") boolean enabled,
            @Value("${antivirus.max.file.size}") DataSize maxFileSize,
            @Value("${antivirus.only.file}") boolean supportFileOnly,
            @Value("${shell.antivirus.command}") String drWebCommand,
            @Value("${shell.antivirus.only.stdin:-false}") boolean useOnlyStdin,
            @Value("${icap.host}") String icapHost,
            @Value("${icap.port}") int icapPort,
            @Value("${icap.service.name}") String icapServiceName,
            @Value("${icap.secondary.host}") String icapSecondaryHost,
            @Value("${icap.secondary.port}") int icapSecondaryPort,
            @Value("${icap.secondary.service.name}") String icapSecondaryServiceName,
            @Value("${use.icap}") boolean useIcap,
            IcapServiceTimeoutConfiguration primaryAntivirusTimeoutConfiguration,
            IcapServiceTimeoutConfiguration secondaryAntivirusTimeoutConfiguration)
    {
        if (useIcap) {
            return new DoubleAntivirus(
                    enabled, maxFileSize, supportFileOnly,
                    new IcapFileScanner(icapHost, icapPort, icapServiceName, enabled, maxFileSize, supportFileOnly, primaryAntivirusTimeoutConfiguration),
                    new IcapFileScanner(icapSecondaryHost, icapSecondaryPort, icapSecondaryServiceName, enabled, maxFileSize, supportFileOnly,
                            secondaryAntivirusTimeoutConfiguration)
            );
        } else {
            return new ShellAntivirus(drWebCommand, useOnlyStdin, enabled, maxFileSize, supportFileOnly);
        }
    }

    @Bean
    public PreviewImageManager previewImageManager(DynamicPropertyManager dynamicPropertyManager) {
        dynamicPropertyManager.addStaticFields(PreviewImageManager.class);
        return new PreviewImageManager();
    }

    @Bean
    public FfTools ffTools(
            @Value("${video.ffmpeg.command}") String ffmpegCommand,
            @Value("${video.ffprobe.command}") String ffprobeCommand)
    {
        return new FfTools(ffmpegCommand, ffprobeCommand);
    }

    // core
    @Bean
    public CpuBound cpuBound(@Value("${cpu.bound.enabled}") boolean enabled) {
        return new CpuBound(enabled);
    }

    @Bean
    public StageProperties stageProperties() {
        return new StageProperties();
    }

    @Bean
    public StageSemaphores stageSemaphores() {
        return new StageSemaphores();
    }

    @Bean
    public DiskWritePolicy diskWritePolicy() {
        return new DiskWritePolicy();
    }

    @Bean
    public MimeTypeDetector mimeTypeDetector() {
        return new MimeTypeDetector();
    }

    @Bean
    public ControlResponseXmlizer controlResponseXmlizer(
            @Value("${data.ssl.urls}")
            boolean dataSslUrls,
            UploaderHosts uploaderHosts,
            UploaderPorts uploaderPorts,
            BannedDomainsProxySettings bannedDomainsProxySettings)
    {
        return new ControlResponseXmlizer(uploaderHosts, uploaderPorts,
                bannedDomainsProxySettings, dataSslUrls);
    }

    @Bean
    public BannedDomainsProxySettings bannedDomainsProxySettings() {
        return new BannedDomainProxySettingsImpl();
    }

    @Bean
    public LocalRequestQueue localRequestQueue() {
        LocalRequestQueue localRequestQueue = new LocalRequestQueue();
        localRequestQueue.setEnabled(false); // https://jira.yandex-team.ru/browse/CHEMODAN-2942
        return localRequestQueue;
    }

    @Bean
    public LocalQueueProcessor localQueueProcessor() {
        LocalQueueProcessor localQueueProcessor = new LocalQueueProcessor();
        localQueueProcessor.setEnabled(false); // https://jira.yandex-team.ru/browse/CHEMODAN-2942
        return localQueueProcessor;
    }

    @Bean
    public LocalQueuePush localQueuePush() {
        return new LocalQueuePush();
    }

    @Bean
    public UploadRegistry uploadRegistry() {
        return new UploadRegistry<MpfsRequestRecord>();
    }

    @Bean
    @OverridableValuePrefix("mpfs_callback")
    public HttpClientConfigurator mpfsCallbackHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    @Qualifier("mpfs_callback")
    public HttpClient mpfsCallbackHttpClient() {
        return mpfsCallbackHttpClientConfigurator().configure();
    }

    @Bean
    public Stages stages() {
        return new Stages();
    }

    @Bean
    public ZipFolderStages zipFolderStages() {
        return new ZipFolderStages();
    }

    @Bean
    public ArchiveManager archiveManager() {
        return new ArchiveManager();
    }

    @Bean
    public UploaderPorts uploaderHttpPorts() {
        return new UploaderPorts();
    }

    @Bean
    public UploaderHosts uploaderHosts(Conductor conductor) {
        if (StringUtils.isEmpty(conductorGroup) && StringUtils.isEmpty(defaultHosts) || StringUtils.isEmpty(slbHost)) {
            logger.warn("Using local mode!");
            String local = HostnameUtils.localHostname();
            return new UploaderHosts(conductor, "", Cf.list(local), local);
        } else {
            return new UploaderHosts(conductor, conductorGroup, Cf.x(defaultHosts.split(",")), slbHost);
        }
    }

    @Bean
    public QueueSensors queueSensors() {
        return new QueueSensors(uploadRegistry());
    }

    @Bean
    public LocalQueueSensors localQueueSensors() {
        return new LocalQueueSensors();
    }

    @Bean
    public ExternalResourceSensors externalResourceSensors() {
        return new ExternalResourceSensors();
    }

    // data

    @Bean
    public LocalFileManager localFileManager(
            @Value("${local.file.manager.dir}")
            File2 dir,
            EnvironmentType environmentType)
    {
        boolean doClean = environmentType == EnvironmentType.TESTS;
        boolean doMake = doClean || environmentType == EnvironmentType.DEVELOPMENT;
        dir = environmentType == EnvironmentType.TESTS ? File2.tmpDir().child("local_files") : dir;
        return new LocalFileManager(dir, doMake, doClean);
    }

    @Bean
    public ChemodanRequestDirector requestDirector() {
        return new ChemodanRequestDirector();
    }

    @Bean
    public RequestStatesHandler requestStatesHandler(
            StageListenerPool<Record<?>> stageListenerPool,
            StageProperties stageProperties, StageSemaphores stageSemaphores,
            UploadRegistry<MpfsRequestRecord> uploadRegistry, Stages stages)
    {
        return new RequestStatesHandler(
                stageListenerPool, stageProperties,
                stageSemaphores, uploadRegistry, stages);
    }

    @Bean
    public StageListenerPoolWithChildren<Record<?>> stageListenerPool() {
        return new StageListenerPoolWithChildren<>();
    }

    // servlets

    @Bean
    public UploadUrlServlet uploadUrlServlet() {
        return new UploadUrlServlet();
    }

    @Bean
    public UploadDeltaUrlServlet uploadDeltaUrlServlet() {
        return new UploadDeltaUrlServlet();
    }

    @Bean
    public ListArchiveServlet listArchiveServlet() {
        return new ListArchiveServlet();
    }

    @Bean
    public ExtractArchiveServlet extractArchiveServlet() {
        return new ExtractArchiveServlet();
    }

    @Bean
    public ExtractFileFromArchiveServlet extractFileFromArchiveServlet() {
        return new ExtractFileFromArchiveServlet();
    }

    @Bean
    public ConvertToMsOoxmlFormatServlet convertToMsOoxmlFormatServlet() {
        return new ConvertToMsOoxmlFormatServlet();
    }

    @Bean
    public HttpServlet generatePreviewServlet() {
        return new GeneratePreviewSyncRequest();
    }

    @Bean
    public HttpServlet generateAlbumPreviewServlet() {
        return new GenerateAlbumPreviewSyncRequest();
    }

    @Bean
    public RegeneratePreviewServlet regeneratePreviewServlet() {
        return new RegeneratePreviewServlet();
    }

    @Bean
    public RegenerateExifServlet regenerateExifServlet() {
        return new RegenerateExifServlet();
    }

    @Bean
    public RecheckVirusesServlet recheckViruses() {
        return new RecheckVirusesServlet();
    }

    @Bean
    public RecalcDigestsServlet recalcDigestsServlet() {
        return new RecalcDigestsServlet();
    }

    @Bean
    public ExportPhotosServlet exportPhotosServlet() {
        return new ExportPhotosServlet();
    }

    @Bean
    public ZipFolderServlet zipFolderServlet() {
        return new ZipFolderServlet(Type.PRIVATE_FOLDER);
    }

    @Bean
    public ZipFolderServlet zipFolderServletPublic() {
        return new ZipFolderServlet(Type.PUBLIC_FOLDER);
    }

    @Bean
    public ZipFolderServlet zipAlbumServlet() {
        return new ZipFolderServlet(Type.ALBUM);
    }

    @Bean
    public ZipFolderServlet zipFilesServlet()
    {
        return new ZipFolderServlet(Type.FILES);
    }

    @Bean
    public PublishServlet publishServlet() {
        return new PublishServlet();
    }

    @Bean
    public UploadFromServiceServlet uploadFromServiceServlet() {
        return new UploadFromServiceServlet();
    }

    @Bean
    public UploadToServiceUrlServlet uploadToServiceUrlServlet() {
        return new UploadToServiceUrlServlet();
    }

    @Bean
    public RequestStatusServlet requestStatusServlet() {
        return new RequestStatusServlet();
    }

    @Bean
    public PatchInstallerServlet patchInstallerServlet() {
        return new PatchInstallerServlet();
    }

    @Bean
    public QueueStatusServlet queueStatusServlet() {
        return new QueueStatusServlet();
    }

    @Bean
    public PingDiskServlet pingControlDaemonServlet() {
        return new PingDiskServlet();
    }

    @Bean
    public CrossdomainXmlServlet crossdomainXmlServlet(EnvironmentType environmentType) {
        EnvironmentType crossdomainEnv = environmentType == EnvironmentType.TESTS ?
                EnvironmentType.DEVELOPMENT : environmentType;
        String path = "/etc/yandex/disk/uploader/crossdomain/crossdomain-" + crossdomainEnv.getValue() + ".xml";
        return new CrossdomainXmlServlet(path);
    }

    @Bean
    public RobotsTxtServlet robotsTxtServlet() {
        return new RobotsTxtServlet();
    }

    @Bean
    public HelpServlet helpServlet() {
        return new HelpServlet();
    }

    @Bean
    public LoadingStatusServlet loadingStatusServlet() {
        return new LoadingStatusServlet();
    }

    @Bean
    public ExtractRotationServlet extractRotationServlet() {
        return new ExtractRotationServlet();
    }

    // hashishin

    @Bean
    @Qualifier("localDiskStorage")
    public DiskRecordStorage<MpfsRequestRecord> diskRecordStorage(
            @Value("${hashishin.dir}")
            File2 recordsDir,
            @Value("${hashishin.dir.done}")
            File2 doneRecordsDir,
            @Value("${hashishin.dir.failed}")
            File2 failedRecordsDir,
            @Value("${hashishin.dir.processing}")
            File2 processingRecordsDir,
            @Value("${hashishin.dir.migration.mode.enabled}")
            boolean migrationModeEnabled,
            @Value("${hashishin.write.thru.minor.updates}")
            boolean writeThruMinorUpdates,
            @Value("${hashishin.write.async}")
            boolean async,
            @Value("${hashishin.in.memory:-false}")
            boolean inMemory,
            IoQueue ioQueue,
            EnvironmentType environmentType)
    {
        boolean doClean = environmentType == EnvironmentType.TESTS;
        boolean doMake = doClean || environmentType == EnvironmentType.DEVELOPMENT;
        return new DiskRecordStorage<>(recordsDir,
                doneRecordsDir, failedRecordsDir, Option.of(processingRecordsDir), Option.of(migrationModeEnabled),
                doMake, doClean,
                writeThruMinorUpdates, inMemory, Option.when(async, ioQueue),
                MpfsRequestRecord.class);
    }

    @Bean
    public IoQueue ioQueue(@Value("${io.queue.delay:-100ms}") Duration delay) {
        return new IoQueue(delay);
    }

    @Bean
    public DiskRecordStorageGc diskRecordStorageGc() {
        return new DiskRecordStorageGc();
    }

    @Bean
    public LoadingStatusManager loadingStatusManager() {
        return new LoadingStatusManager();
    }

    @Bean
    public LoadingStatusStrategy laBasedStrategy() {
        LaBasedStrategy laBasedStrategy = new LaBasedStrategy();
        laBasedStrategy.setOperatingSystemMXBean(ManagementFactory.getOperatingSystemMXBean());
        return laBasedStrategy;
    }

    @Bean
    public String diskDeviceName() {
        if (StringUtils.isEmpty(diskDeviceOverride)) {
            return DiskDeviceLinuxUtils.getDeviceNameForFile(spoolDir);
        } else {
            return diskDeviceOverride;
        }
    }

    @Bean
    public String networkInterfaceName() {
        if (StringUtils.isEmpty(networkInterfaceOverride)) {
            return NetworkInterfaceLinuxUtils.detectActiveNetworkInterface();
        } else {
            return networkInterfaceOverride;
        }
    }

    @Bean
    public LoadingStatusStrategy diskIoBasedStrategy(EnvironmentType environmentType, Location myLocation) {
        if (isDevEnv(environmentType) || isCloud(myLocation)) {
            return new DiskIoBasedStrategy() {
                @Override
                public void refresh() {}
            };
        }

        String deviceName = diskDeviceName();
        Integer diskSectorSize = deviceSectorSize();
        DiskIoBasedStrategy diskIoBasedStrategy = new DiskIoBasedStrategy();
        diskIoBasedStrategy.setSectorSize(diskSectorSize);
        diskIoBasedStrategy.setDeviceName(deviceName);
        diskIoBasedStrategy.setStatFile(new File2("/proc/diskstats"));
        diskIoBasedStrategy.setSleepBeforeFirstRun(false);
        diskIoBasedStrategy.setDelay(Duration.standardSeconds(1));
        return diskIoBasedStrategy;
    }

    @Bean
    public LoadingStatusStrategy diskIopsBasedStrategy(EnvironmentType environmentType, Location myLocation) {
        if (isDevEnv(environmentType) || isCloud(myLocation)) {
            return new DiskIopsBasedStrategy() {
                @Override
                public void refresh() {}
            };
        }

        String deviceName = diskDeviceName();
        DiskIopsBasedStrategy diskIopsBasedStrategy = new DiskIopsBasedStrategy();
        diskIopsBasedStrategy.setDeviceName(deviceName);
        diskIopsBasedStrategy.setStatFile(new File2("/proc/diskstats"));
        diskIopsBasedStrategy.setSleepBeforeFirstRun(false);
        diskIopsBasedStrategy.setDelay(Duration.standardSeconds(1));
        return diskIopsBasedStrategy;
    }

    private boolean isCloud(Location myLocation) {
        return myLocation.getLocationType().isCloud();
    }

    @Bean
    public Integer deviceSectorSize() {
        if (StringUtils.isEmpty(deviceSectorSizeOverride)) {
            return DiskDeviceLinuxUtils.getDeviceSectorSize(diskDeviceName());
        } else {
            return Integer.valueOf(deviceSectorSizeOverride);
        }
    }

    @Bean
    public LoadingStatusStrategy mulcaQueueSizeLoadingStatusStrategy(QueueSensors queueSensors) {
        return new MulcaQueueSizeLoadingStatusStrategy(queueSensors);
    }

    @Bean
    public LoadingStatusStrategy userQueueSizeLoadingStatusStrategy(QueueSensors queueSensors) {
        return new UserQueueSizeLoadingStatusStrategy(queueSensors);
    }

    @Bean
    public LoadingStatusStrategy exponentialUserQueueInitialLoadingStatusStrategy(QueueSensors queueSensors) {
        return new ExponentialUserQueueInitialLoadingStatusStrategy(queueSensors);
    }

    @Bean
    public LoadingStatusStrategy exponentialUserQueueInProgressLoadingStatusStrategy(QueueSensors queueSensors) {
        return new ExponentialUserQueueInProgressLoadingStatusStrategy(queueSensors);
    }

    @Bean
    public LoadingStatusStrategy networkIoBasedStrategy(EnvironmentType environmentType) {
        if (isDevEnv(environmentType)) {
            return new NetworkIoBasedStrategy() {
                public void refresh() {}
            };
        }

        NetworkIoBasedStrategy networkIoBasedStrategy = new NetworkIoBasedStrategy();
        networkIoBasedStrategy.setNetworkInterface(networkInterfaceName());
        networkIoBasedStrategy.setStatFile(new File2("/proc/net/dev"));
        return networkIoBasedStrategy;
    }

    @Bean
    public NetworkIoLoadingStatusDelayHolder networkIoLoadingStatusDelayHolder() {
        return new NetworkIoLoadingStatusDelayHolder();
    }

    private boolean isDevEnv(EnvironmentType environmentType) {
        return environmentType == EnvironmentType.DEVELOPMENT || environmentType == EnvironmentType.TESTS;
    }

    @Bean
    public MulcaUploadManager mulcaUploadManager() {
        return new MulcaUploadManager();
    }

    @Bean
    @Qualifier("simultaneousMulcaUpload")
    public ExecutorService simultaneousMulcaUploadExecutorService(
            @Value("${uploader.simultaneous.mulca.upload.threads}") Integer threads)
    {
        return Executors.newFixedThreadPool(threads);
    }

    @Bean
    public SimultaneousMulcaUploadManager simultaneousMulcaUploadManager(
            @Qualifier("simultaneousMulcaUpload") ExecutorService executorService,
            Stages stages,
            UploadRegistry<MpfsRequestRecord> uploadRegistry,
            @Qualifier("simultaneousMulcaUpload") BleedingEdge bleedingEdge)
    {
        return new SimultaneousMulcaUploadManager(executorService, stages, uploadRegistry, bleedingEdge);
    }

    @Bean
    public StageProcessor stageProcessor() {
        return new LoggableStageProcessor();
    }

    @Bean
    public SyncRequestProcessor syncRequestProcessor(
            Stages stages,
            StageProcessor stageProcessor)
    {
        return new SyncRequestProcessor(stages, stageProcessor);
    }

    @Bean
    public Dcraw dcraw() {
        return new Dcraw();
    }

    @Bean
    public HeifConverter heifConverter(@Value("${heif.converter.path}") String heifConverterPath) {
        return new HeifConverter(heifConverterPath);
    }

    @Bean
    public MaintenanceFileChecker maintenanceFileChecker(AppName appName) {
        return new MaintenanceFileChecker(appName);
    }

    @Bean
    public LogsFreeSizeChecker availabilityChecker() {
        return new LogsFreeSizeChecker();
    }

    @Bean
    public ExternalResourceSemaphores externalResourceSemaphores() {
        return new ExternalResourceSemaphores(PropertiesHolder.properties());
    }

    @Bean
    public OfficeUploadManager officeUploadManager() {
        return new OfficeUploadManager();
    }

    @Bean
    public OauthClient oauthClient(
            @Value("${oauth.consumer}") String consumer,
            @Value("${oauth.host}") String host,
            @Value("${oauth.client.id}") String clientId,
            @Value("${oauth.client.secret}") String clientSecret)
    {
        return new OauthClient(host, consumer, clientId, clientSecret, oauthHttpClientConfigurator().configure());
    }

    @Bean
    @OverridableValuePrefix("oauth")
    public HttpClientConfigurator oauthHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public UploadTimeoutHolder uploadTimeoutHolder(
            @Value("${uploader.servlet.commit.upload.external.wait.delay}") Duration extenalClientsTimeout,
            @Value("${uploader.servlet.commit.upload.max.wait.delay}") Duration maxTimeout,
            @Value("${uploader.servlet.commit.upload.min.wait.delay}") Duration minTimeout)
    {
        return new UploadTimeoutHolder(extenalClientsTimeout, maxTimeout, minTimeout);
    }

    @Bean
    public LibMagicMimeTypeDetector libMagicMimeTypeDetector(
            @Value("${file.command.path}") String fileCommandPath,
            @Value("${file.mime.detection.additional-args}") CommaSeparated additionalArgs,
            @Value("${file.mime.detection.timeout}") Duration mimeDetectionTimeout,
            Optional<List<MimeTypeCorrector>> correctors)
    {
        return new LibMagicMimeTypeDetector(fileCommandPath, additionalArgs.list, mimeDetectionTimeout,
                correctors.map(Cf::x).orElse(Cf.list()));
    }

    @Bean
    public FfprobeMimeTypeCorrector ffprobeMimeTypeCorrector(
            @Value("${video.ffprobe.command}") String ffprobePath,
            @Value("${ffprobe.mime.correction.timeout}") Duration ffprobeTimeout)
    {
        return new FfprobeMimeTypeCorrector(ffprobePath, ffprobeTimeout);
    }

    @Bean
    public UserUploadSpeedLimitManager userUploadSpeedLimitManager() {
        return new UserUploadSpeedLimitManager();
    }
}
