package ru.yandex.chemodan.uploader.config;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.inside.passport.tvm2.AddServiceTicketInterceptor;
import ru.yandex.inside.passport.tvm2.ByHostClientResolver;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.misc.io.http.UrlUtils;

/**
 * @author yashunsky
 */
@Configuration
@Import({
        UploaderCoreContextConfiguration.class,
        Tvm2BaseContextConfiguration.class,
})
public class UploaderCoreContextConfigurationForTests {

    @Autowired
    private Tvm2 tvm;

    @Bean
    public AddServiceTicketInterceptor addServiceTicketInterceptor(
            @Value("${docviewer.worker.url}") String docviewerWorkerUrl,
            @Value("${docviewer.backend.url}") String docviewerBackendUrl,
            @Value("${tvm.dv.client-id}") int dvTvmClientId)
    {
        return tvm.serviceTicketInterceptor(new ByHostClientResolver(Cf.map(
                UrlUtils.extractHost(docviewerWorkerUrl), dvTvmClientId,
                UrlUtils.extractHost(docviewerBackendUrl), dvTvmClientId)));
    }

    @PostConstruct
    public void startTvm() {
        tvm.start();
    }
}
