package ru.yandex.chemodan.uploader.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.uploader.web.data.SyncUploadServlet;
import ru.yandex.chemodan.uploader.web.data.UploadDeltaTargetServlet;
import ru.yandex.chemodan.uploader.web.data.UploadFromOfficeServlet;
import ru.yandex.chemodan.uploader.web.data.UploadTargetServlet;
import ru.yandex.chemodan.uploader.web.data.UploadToServiceTargetServlet;
import ru.yandex.commune.uploader.local.file.LocalFileManagerGc;

/**
 * @author vavinov
 */
@Configuration
public class UploaderDataWorkerContextConfiguration {
    @Bean
    public LocalFileManagerGc localFileManagerGc() {
        return new LocalFileManagerGc();
    }

    @Bean
    public UploadTargetServlet uploadTargetServlet() {
        return new UploadTargetServlet();
    }

    @Bean
    public UploadDeltaTargetServlet uploadDeltaTargetServlet() {
        return new UploadDeltaTargetServlet();
    }

    @Bean
    public UploadToServiceTargetServlet uploadToServiceTargetServlet() {
        return new UploadToServiceTargetServlet();
    }

    @Bean
    public SyncUploadServlet syncUploadServlet() {
        return new SyncUploadServlet();
    }

    @Bean
    public UploadFromOfficeServlet uploadFromOfficeServlet() {
        return new UploadFromOfficeServlet();
    }

}

