package ru.yandex.chemodan.uploader.docviewer;

import java.net.URI;

import org.dom4j.Element;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.io.InputStreamSource;

public interface DocviewerClient {

    InputStreamSource getDocumentPreview(MulcaId mulcaId, PassportUidOrZero uid, String contentType);

    void startConvertToHtml(PassportUidOrZero uid, String sourceUrl, Option<String> contentType);

    void startConvertToHtml(PassportUidOrZero uid, String sourceUrl, Option<String> contentType, boolean warmup);

    InputStreamSource getSourceInternal(PassportUidOrZero uid, String docviewerDownloadUUID);

    Element urlInfo(PassportUidOrZero uid, String sourceUrl);

    InputStreamSource convertToMsOoxmlFormat(URI url, PassportUidOrZero uid,
            Option<String> archivePath, Option<String> contentType);

    boolean isDocumentSupportedByDocviewer(Option<String> contentType, Option<Long> sourceLength);

    boolean isPreviewSupported(String contentType);

    String correctMimeTypeByFileNameIfUnknown(String mimeType, Option<String> filename);

    boolean remoteEnabled();

    void updateCachedConvertationInfo();
}
