package ru.yandex.chemodan.uploader.docviewer;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import javax.inject.Qualifier;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.misc.dataSize.DataSize;

/**
 * Vsevolod Tolstopyatov (qwwdfsad)
 */

@Configuration
public class DocviewerContextConfiguration {
    @Qualifier
    @Retention(RetentionPolicy.RUNTIME)
    public @interface DocviewerHttpClientConfigurator {
    }

    @Bean
    public DocviewerClient docviewerClient(
            @Value("${docviewer.worker.url}") String docviewerWorkerUrl,
            @Value("${docviewer.backend.url}") String docviewerBackendUrl,
            @Value("${docviewer.max.file.length}") DataSize docviewerMaxFileLength,
            @DocviewerHttpClientConfigurator
                    HttpClientConfigurator docviewerHttpClientConfigurator,
            @Value("${docviewer.use-remote}") boolean useRemoteDvInfo)
    {
        HttpClient httpClient = docviewerHttpClientConfigurator.configure();
        return new DocviewerClientImpl(docviewerWorkerUrl, docviewerBackendUrl,
                docviewerMaxFileLength, useRemoteDvInfo, httpClient);
    }

    @Bean
    public DocviewerInfoExtractor docviewerExtractor() {
        return new DocviewerInfoExtractor();
    }


    @Bean
    @DocviewerHttpClientConfigurator
    @OverridableValuePrefix("docviewer")
    public HttpClientConfigurator docviewerHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
