package ru.yandex.chemodan.uploader.docviewer;

import javax.annotation.PostConstruct;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.misc.worker.DelayingWorkerThread;

/**
 * Vsevolod Tolstopyatov (qwwdfsad)
 */
public class DocviewerInfoExtractor extends DelayingWorkerThread {
    private static final Duration delayTime = Duration.standardMinutes(5);
    @Autowired
    private DocviewerClient client;

    public DocviewerInfoExtractor() {
        super(DocviewerInfoExtractor.class.getName());
    }

    @Override
    protected void executePeriodically() throws Exception {
        if (!client.remoteEnabled()) {
            return;
        }

        client.updateCachedConvertationInfo();
    }

    @Override
    protected long delayBetweenExecutionsMillis() {
        return delayTime.getMillis();
    }

    @PostConstruct
    public void init() {
        this.startGracefully();
    }
}
