package ru.yandex.chemodan.uploader.exif;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.uploader.preview.HeifConverter;
import ru.yandex.chemodan.uploader.registry.record.status.ExifInfo;
import ru.yandex.chemodan.uploader.services.ServiceImageInfo;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class ExifHelper {
    private static final Logger logger = LoggerFactory.getLogger(ExifHelper.class);

    public static ExifInfo extractExif(File2 src, String contentType, Option<ServiceImageInfo> serviceImageInfo) {
        if (serviceImageInfo.isPresent()) {
            return new ExifInfo(serviceImageInfo.get().creationTime, serviceImageInfo.get().location);
        } else if ("image/heif".equals(contentType)) {
            // Upyachka: fast fix for heif exif extraction.
            // Really we should extract exif from original heic file,
            // but now we use converted from heic jpg preview for extracting exif info.
            Option<File2> result = src.getParent().get().listRegularFiles()
                    .filter(f -> StringUtils.endsWithIgnoreCase(f.getName(), HeifConverter.getConvertedHeifImagePostfix()))
                    .firstO();
            if (result.isPresent()) {
                return ExifTool.INSTANCE.getExif(result.get());
            } else {
                logger.debug("Couldn't find converted to jpg heif preview, return empty exif");
                return new ExifInfo(Option.empty(), Option.empty());
            }
        } else {
            return ExifTool.INSTANCE.getExif(src);
        }
    }

}
