package ru.yandex.chemodan.uploader.http;

import org.eclipse.jetty.server.Server;

import ru.yandex.chemodan.uploader.registry.record.MpfsRequestRecord;
import ru.yandex.commune.uploader.registry.UploadRegistry;
import ru.yandex.misc.web.servletContainer.SingleWarJetty;

/**
 * @author akirakozov
 */
public class UploaderDataJetty extends SingleWarJetty {
    private final UploadRegistry<MpfsRequestRecord> uploadRegistry;

    public UploaderDataJetty(UploadRegistry<MpfsRequestRecord> uploadRegistry) {
        this.uploadRegistry = uploadRegistry;
    }

    @Override
    protected void addPushRequestIdHandler(Server server) {
        UploaderDataRequestHandler handler = new UploaderDataRequestHandler(uploadRegistry);
        handler.setHandler(server.getHandler());
        server.setHandler(handler);
    }
}
