package ru.yandex.chemodan.uploader.installer;

import java.util.Arrays;

import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.serialize.BenderJsonSerializer;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class InstallerModifier {
    private static final Logger logger = LoggerFactory.getLogger(InstallerModifier.class);
    private static final BytesMatcher matcher = new BytesMatcher();
    private static final BenderJsonSerializer<InstallerModifierParams> serializer =
            Bender.jsonSerializer(InstallerModifierParams.class);


    static final byte[] START_MARKER = "B94FA2E208DD4e97979604809696358E".getBytes();
    static final byte[] END_MARKER = "DEC70B359B524b5cA98CDA849B5A0788".getBytes();
    static final int ZERO_COUNT = 1024; // 1kb

    public void patchInstaller(byte installerData[], InstallerModifierParams params) {
        int ind = matcher.findPatternIndexFromEnd(installerData, END_MARKER);
        checkMarkerCondition(ind, installerData);

        int jsonStart = ind - ZERO_COUNT;
        byte[] packedParams = serializer.serializeJson(params);
        if (packedParams.length <= ZERO_COUNT) {
            System.arraycopy(packedParams, 0, installerData, jsonStart, packedParams.length);
        } else {
            logger.error("Error while applying parameters to light installer: parameters JSON too long.");
        }
    }

    private void checkMarkerCondition(int ind, byte[] installerData) {
        Check.isTrue(ind >= 0, "End marker is not found in installer");
        int startMarkerInd = ind - ZERO_COUNT - START_MARKER.length;
        Check.isTrue(startMarkerInd >= 0, "Start marker is not found in installer");
        byte[] res = Arrays.copyOfRange(installerData, startMarkerInd, startMarkerInd + START_MARKER.length);
        Check.arraysEquals(res, START_MARKER);
    }
}
