package ru.yandex.chemodan.uploader.installer;

import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.time.TimeUtils;

/**
 * Installer Modifier params, set up by blocks.
 *
 * @author buberman
 */
@BenderBindAllFields
public class InstallerModifierParams {
    public static final DateTimeFormatter DATE_PATTERN = DateTimeFormat.forPattern("yyyy-MM-dd")
            .withZone(TimeUtils.EUROPE_MOSCOW_TIME_ZONE);

    private Option<String> key;
    private Option<String> yuid;
    @BenderPart(name = "open_url_after_install", strictName = true)
    private Option<String> openUrlAfterInstall;
    private String src;
    private String date;

    public static InstallerModifierParams build(Option<String> yuid, String src, Option<String> openUrlAfterInstall) {
        InstallerModifierParams result = new InstallerModifierParams();

        result.key = Option.empty();
        result.openUrlAfterInstall = openUrlAfterInstall;
        result.yuid = yuid;
        result.src = src;
        result.date = Instant.now().toString(DATE_PATTERN);
        return result;
    }

    public InstallerModifierParams setKey(String key) {
        this.key = Option.of(key);
        return this;
    }
}
