package ru.yandex.chemodan.uploader.local.queue;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.commune.monitoring.Safe;
import ru.yandex.commune.uploader.local.queue.LocalQueueProcessor;
import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaContainer;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author vavinov
 */
public class LocalQueueSensors implements MonicaContainer {
    @Autowired
    private LocalQueueProcessor localQueueProcessor;

    @Safe
    @MonicaMetric
    @GroupByDefault
    public long getTotalPermanentlyFailedRequests() {
        return localQueueProcessor.getTotalPermanentlyFailedRequests();
    }

    @Safe
    @MonicaMetric
    @GroupByDefault
    public long getTotalCompletedRequests() {
        return localQueueProcessor.getTotalCompletedRequests();
    }

    @Override
    public MetricGroupName groupName(String instanceName) {
        return new MetricGroupName(
                "local-queue",
                new MetricName("queue", "local"),
                "Local queue"
        );
    }
}
