package ru.yandex.chemodan.uploader.log;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.log.TskvLogger;
import ru.yandex.chemodan.uploader.UidOrSpecial;
import ru.yandex.inside.mulca.MulcaId;

/**
 * @author bursy
 */
public class UploaderExifLogger {
    public static final TskvLogger tskvLogger = new TskvLogger("uploader-exif");

    public static void log(String exifJson, MulcaId fileMulcaId, UidOrSpecial uid, String path, Option<Long> length) {
        String formattedExif = Cf.x(exifJson.split("\\n")).map(String::trim).mkString(" ");
        tskvLogger.log(Tuple2List.fromPairs(
                "stid", fileMulcaId.getStid(),
                "uid", uid.toSpecialOrUidString(),
                "path", path,
                "size", length.map(String::valueOf).getOrElse("-"),
                "exif", formattedExif
        ));
    }
}
