package ru.yandex.chemodan.uploader.log;

import org.apache.log4j.PatternLayout;

import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.version.AppName;

/**
 * @author tolmalev
 */
public class UploaderLog4jHelper extends Log4jHelper {

    public static void configureEventsLogger(AppName appName) {
        configureEventsLogger(appName, false);
        configureEventsLogger(appName, true);
    }

    private static void configureEventsLogger(AppName appName, boolean isTskvLog) {
        PatternLayout layout = isTskvLog
                ? getTskvLogPatternLayout("ydisk-events-log-" + appName.appName())
                : new UploaderEventsLogPatternLayout();

        appenderBuilder()
                .appName(appName)
                .postfix("-events")
                .tskvLog(isTskvLog)
                .layout(layout)
                .level(ru.yandex.misc.log.mlf.Level.DEBUG)
                .name(isTskvLog ? "ru.yandex.chemodan.uploader.log.tskv.Events" : Events.class.getName())
                .build();
    }

    public static void configureStatLogger(AppName appName) {
        appenderBuilder()
                .appName(appName)
                .postfix("-stat")
                .tskvLog(false)
                .level(ru.yandex.misc.log.mlf.Level.INFO)
                .name(UploadStatisticLogger.class.getName())
                .build();
    }

    public static void configureAntifoLogger(AppName appName) {
        appenderBuilder()
                .appName(appName)
                .postfix("-antifo")
                .tskvLog(false)
                .level(ru.yandex.misc.log.mlf.Level.INFO)
                .name(ZipStreamStatLogger.class.getName())
                .build();
    }

    public static void configureUploaderExLogging() {
        if (Boolean.valueOf(PropertiesHolder.properties().getProperty("uploader.enable.trace"))) {
            configureLogger("ru.yandex.commune.uploader", ru.yandex.misc.log.mlf.Level.TRACE);
        }
    }

    public static void configureExifLogger(AppName appName) {
        appenderBuilder()
                .appName(appName)
                .name(UploaderExifLogger.tskvLogger.name)
                .postfix("-exif")
                .layout(new UploaderExifTskvLogPatternLayout())
                .build();
    }
}
