package ru.yandex.chemodan.uploader.log;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.mpfs.MpfsHid;
import ru.yandex.chemodan.util.tskv.TskvUtils;
import ru.yandex.commune.uploader.registry.UploadRequestId;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class ZipStreamStatLogger {
    private static final Logger logger = LoggerFactory.getLogger(ZipStreamStatLogger.class);

    public static void logFileToZipStreamed(UploadRequestId reqId, MpfsHid hid, String name,
            String mediaType, boolean auth, DataSize bytes)
    {
        try {
            logger.info(formatLogMessage(reqId, new DateTime(DateTimeZone.getDefault()),
                    hid, name, mediaType, auth, bytes));
        } catch (Exception ex) {
            logger.debug("Couldn't log " + ex.getMessage(), ex);
        }
    }

    static String formatLogMessage(UploadRequestId reqId, DateTime now, MpfsHid hid, String name,
            String mediaType, boolean auth, DataSize bytes)
    {
        MapF<String, String> data = Cf.linkedHashMap();
        data.put("id", reqId.toString());
        data.put("tskv_format", "ydisk-uploader-zip-traffic-log");
        data.put("timestamp", StatTimeFormatterUtils.TIMESTAMP_FORMATTER.print(now));
        data.put("timezone", StatTimeFormatterUtils.TIMEZONE_FORMATTER.print(now));
        data.put("unixtime", String.valueOf(now.getMillis() / 1000));
        data.put("hid", hid.toString());
        data.put("name", name);
        data.put("media-type", mediaType);
        data.put("auth", String.valueOf(auth));
        data.put("bytes", bytes.toString());

        return TskvUtils.formatTskvLine(data);
    }
}
