package ru.yandex.chemodan.uploader.mail;

import java.io.IOException;
import java.io.InputStream;

import javax.mail.MessagingException;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.commune.uploader.util.http.Content;
import ru.yandex.commune.uploader.util.http.ContentUtils;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.mulca.MulcaRange;
import ru.yandex.inside.mulca.MulcaUtils;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.wmi.WmiAttachmentInfo;
import ru.yandex.inside.wmi.WmiClient;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.InputStreamSource;

/**
 * @author vavinov
 */
public class MailClient {
    @Autowired
    private MulcaClient mulcaClient;
    @Autowired
    private WmiClient wmiClient;

    public Content getAttachStream2(final PassportUid uid, final String mid, final String hid) {
        final WmiAttachmentInfo info = wmiClient.getAttachmentInfo(uid, mid, hid);
        return ContentUtils.withType(info.getFullContentType().getOrElse(""), new InputStreamSource() {
            @SuppressWarnings("resource")
            public InputStream getInput() throws IOException {
                try {
                    // TODO: handle rfc822 case
                    InputStream in = mulcaClient.downloadWithRange(
                                MulcaId.valueOf(info.stid, ""),
                                new MulcaRange(info.offsetBegin, info.offsetEnd)
                            ).getInput();
                    return MulcaUtils.decode(in, info.encoding.getOrElse(""));
                } catch (MessagingException e) {
                    throw ExceptionUtils.translate(e);
                }
            }
        });
    }

}
