package ru.yandex.chemodan.uploader.mulca;

import java.net.URI;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import lombok.SneakyThrows;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.serialize.JsonParser;
import ru.yandex.inside.mulca.MulcaClient;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.io.InputStreamSourceUtils;

public class MulcaAndAvatarsClient extends MulcaClient {

    private static final String toPng = String.format("{%s}", String.join(",", Cf.map(
            "width", "inf",
            "height", "inf",
            "command", "resize",
            "typemap", "*:png"
    ).entries().map((k, v) -> String.format("\"%s\":\"%s\"", k, v))));

    private final Pattern avatarsStidPattern = Pattern.compile("^ava:([^:]+):([^:]+):([^:]+)$");
    private final String avatarsUploadHost;
    private final String avatarsDownloadHost;

    public MulcaAndAvatarsClient(MulcaClient base, String avatarsUploadHost, String avatarsDownloadHost) {
        super(base.getClient(), base.getMulcaGateUrl(), base.getShapingSettings(), base.getMulcaZeroSizeStids());
        this.avatarsUploadHost = avatarsUploadHost;
        this.avatarsDownloadHost = avatarsDownloadHost;
    }

    @Override
    public URI getDownloadUri(MulcaId mulcaId) {
        Matcher m = avatarsStidPattern.matcher(mulcaId.getStid());
        if (m.matches()) {
            return URI.create(String.format("http://%s%s", avatarsDownloadHost, sign(m.group(1), m.group(2), m.group(3), toPng)));
        } else {
            return super.getDownloadUri(mulcaId);
        }
    }

    @SneakyThrows
    private String sign(String ns, String gr, String id, String th) {
        return getClient().execute(
                new HttpGet(String.format("http://%s/genurlsign-%s/%s/%s?thumbnail=%s", avatarsUploadHost, ns, gr, id, URLEncoder.encode(th, "utf8"))),
                resposne -> JsonParser
                        .getInstance()
                        .parseObject(InputStreamSourceUtils.wrap(resposne.getEntity().getContent()).readText("utf-8"))
                        .getByPathO("path")
                        .cast(JsonString.class)
                        .map(JsonString::getString)
                        .get());
    }

}
