package ru.yandex.chemodan.uploader.mulca;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.uploader.log.DescribableResult;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.misc.lang.DefaultToString;

/**
 * Wrapper for Option because
 *  - it will probably be easier for jackson
 *  - it will probably turn into Either, and I want to spare client code from extra angle brackets
 *
 * @author vavinov
 */
// XXX: not renamed to MulcaUploadInfoOption for back-compatibility
public class MulcaIdOption extends DefaultToString implements DescribableResult {
    @JsonProperty
    private final Option<MulcaUploadInfo> mulcaUploadInfo;

    private MulcaIdOption(Option<MulcaUploadInfo> mulcaUploadInfo) {
        this.mulcaUploadInfo = mulcaUploadInfo;
    }

    @JsonCreator
    public MulcaIdOption(
            @JsonProperty("mulcaId") @Nullable Option<MulcaId> mulcaId,
            @JsonProperty("mulcaUploadInfo") @Nullable Option<MulcaUploadInfo> mulcaUploadInfo)
    {
        this.mulcaUploadInfo = mulcaUploadInfo != null ?
                mulcaUploadInfo :
                mulcaId.map(MulcaUploadInfo::fromMulcaId);
    }

    public Option<MulcaUploadInfo> getMulcaUploadInfo() {
        return mulcaUploadInfo;
    }

    public static MulcaIdOption some(MulcaUploadInfo mulcaUploadInfo) {
        return new MulcaIdOption(Option.of(mulcaUploadInfo));
    }

    public static MulcaIdOption none() {
        return new MulcaIdOption(Option.empty());
    }

    @Override
    public MapF<String, String> describe() {
        if (mulcaUploadInfo.isPresent()) {
            return mulcaUploadInfo.get().describe();
        } else {
            return Cf.map("mulca_id", "").plus1("size", "");
        }
    }

}
