package ru.yandex.chemodan.uploader.mulca;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.uploader.log.DescribableResult;
import ru.yandex.inside.mulca.MulcaId;

/**
 * @author akirakozov
 */
public class MulcaUploadInfo implements DescribableResult {
    @JsonProperty
    private final MulcaId mulcaId;

    @JsonProperty
    private final Option<Long> size;

    @JsonCreator
    public MulcaUploadInfo(
            @JsonProperty("mulcaId") MulcaId mulcaId,
            @JsonProperty("size") Option<Long> size)
    {
        this.mulcaId = mulcaId;
        this.size = size;
    }

    public MulcaId getMulcaId() {
        return mulcaId;
    }

    public Option<Long> getSize() {
        return size;
    }

    public static MulcaUploadInfo fromMulcaId(MulcaId mulcaId) {
        return new MulcaUploadInfo(mulcaId, Option.empty());
    }

    @Override
    public MapF<String, String> describe() {
        return Cf.map("mulca_id", mulcaId.toSerializedString())
                .plus1("size", size.map(Cf.Long.toStringF()).getOrElse(""));
    }
}
