package ru.yandex.chemodan.uploader.office;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.commune.uploader.log.DescribableResult;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author akirakozov
 */
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class MpfsInitialStoreInfo implements DescribableResult {
    public final long uid;
    @BenderPart(name = "file-id", strictName = true)
    public final String fileId;
    public final String path;
    public final String callback;
    @BenderPart(name = "max-file-size", strictName = true)
    public final long maxFileSize;
    public final String service;
    @BenderPart(name = "api", strictName = true)
    public final String apiVersion;

    public static final BenderParserSerializer<MpfsInitialStoreInfo> PS = Bender.cons(MpfsInitialStoreInfo.class);

    public MpfsInitialStoreInfo(
            long uid,
            String fileId,
            String path,
            String callback,
            long maxFileSize,
            String service,
            String apiVersion)
    {
        this.uid = uid;
        this.fileId = fileId;
        this.path = path;
        this.callback = callback;
        this.maxFileSize = maxFileSize;
        this.service = service;
        this.apiVersion = apiVersion;
    }

    @Override
    public MapF<String, String> describe() {
        return Cf.map("uid", Long.toString(uid))
                .plus1("path", path)
                .plus1("callback", callback)
                .plus1("max-file-size", Long.toString(maxFileSize));
    }
}
