package ru.yandex.chemodan.uploader.office;

import java.util.Map;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.uploader.log.DescribableResult;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author akirakozov
 */
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class MpfsOfficeStoreResponseInfo implements DescribableResult {

    @BenderPart(name = "store_info", strictName = true)
    public final Option<MpfsInitialStoreInfo> storeInfo;

    @BenderPart(name = "response_body", strictName = true)
    public final String body;
    @BenderPart(name = "response_code", strictName = true)
    public final int statusCode;
    @BenderPart(name = "response_headers", strictName = true)
    public final Map<String, String> headers;

    public static final BenderParserSerializer<MpfsOfficeStoreResponseInfo> PS =
            Bender.cons(MpfsOfficeStoreResponseInfo.class);

    public MpfsOfficeStoreResponseInfo(
            Option<MpfsInitialStoreInfo> storeInfo,
            String body,
            int statusCode,
            Map<String, String> headers)
    {
        this.storeInfo = storeInfo;
        this.body = body;
        this.statusCode = statusCode;
        this.headers = headers;
    }


    @Override
    public MapF<String, String> describe() {
        MapF<String, String> params =
                Cf.map("response_code", Integer.toString(statusCode))
                        .plus1("headers", headers.toString());
        if (storeInfo.isPresent()) {
            params = params.plus(storeInfo.get().describe());
        }
        return params;
    }
}
