package ru.yandex.chemodan.uploader.preview;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.commune.image.RotateAngle;
import ru.yandex.commune.image.imageMagick.ImageMagick;
import ru.yandex.commune.image.imageMagick.ImageMagickPingReportParser;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class ConvertReportParser {
    private static final Logger logger = LoggerFactory.getLogger(PreviewImageManager.class);

    public PreviewInfo parseReport(String report, String targetFileName) {
        ImageFormat previewFormat = determinePreviewFormat(report);
        Option<Dimension> origSizeO = getOrigSizeO(report);
        Dimension previewSize = getPreviewSize(report, targetFileName);
        Option<RotateAngle> rotateAngle = ImageMagickPingReportParser.getRotateAngle(report);

        return new PreviewInfo(previewFormat, origSizeO, previewSize, rotateAngle);
    }

    private Option<Dimension> getOrigSizeO(String report) {
        try {
            return Option.of(ImageMagickPingReportParser.getOriginalSize(report));
        } catch (Exception e) {
            logger.warn("Couldn't find original image size: " + e.getMessage(), e);
            return Option.empty();
        }
    }

    private static Pattern createPattern(String name) {
        String regexp = "\\b" + name + ":([0-9]+)x([0-9]+)";
        return Pattern.compile(regexp, Pattern.MULTILINE);
    }

    private Dimension getPreviewSize(String report, String name) {
        Pattern p = createPattern(name);
        Matcher m = p.matcher(report);
        if (m.find()) {
            String width = m.group(1);
            String height = m.group(2);
            return Dimension.valueOf(Integer.parseInt(width), Integer.parseInt(height));
        } else {
            throw new IllegalStateException("Preview size not found in output report");
        }
    }

    private ImageFormat determinePreviewFormat(String report) {
        return ImageMagick.determineThumbnailFormat(ImageMagickPingReportParser.getImageFormat(report));
    }
}
