package ru.yandex.chemodan.uploader.preview;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.io.exec.ErrorExitCodeException;
import ru.yandex.misc.io.exec.ExecUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author nshmakov
 */
public class Dcraw {

    private static final Logger logger = LoggerFactory.getLogger(Dcraw.class);

    public File2 extractPreviewFromRawImage(File2 rawImage) {
        File2 resultFile = rawImage.sibling(rawImage.getName() + ".extracted");

        try {
            ExecUtils.executeRedirectingOutput(Cf.list("dcraw", "-e", "-c", rawImage.getAbsolutePath()), resultFile.getFile());
        } catch (ErrorExitCodeException ex) {
            logger.warn("Dcraw exited with error code", ex);
        }

        Check.isTrue(resultFile.getFile().length() != 0, "No embedded preview in RAW file");
        return resultFile;
    }
}
