package ru.yandex.chemodan.uploader.preview;

import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.ExecUtils2;
import ru.yandex.misc.io.file.File2;

/**
 * @author metal
 */
public class FoggingManager {
    @Value("${imagemagick.convert}")
    private String convertCmd;

    public void fogImageWithColor(File2 image, String colorName, int intensity) {
        ListF<String> cmd = Cf.list(convertCmd,
                image.getAbsolutePath(), // source
                "-fill", colorName,
                "-colorize", intensity + "%",
                image.getAbsolutePath()); // result

        ExecUtils2.executeWithLogging(cmd);
    }
}
