package ru.yandex.chemodan.uploader.preview;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.io.exec.ExecUtils;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class HeifConverter {
    private static final Logger logger = LoggerFactory.getLogger(HeifConverter.class);

    private final String heifConverterPath;

    public HeifConverter(String heifConverterPath) {
        this.heifConverterPath = heifConverterPath;
    }

    public File2 convertHeifToJpeg(File2 heifImage) {
        File2 resultFile = heifImage.sibling(heifImage.getName() + getConvertedHeifImagePostfix());

        ExecResult result = ExecUtils.executeGrabbingOutput(
                Cf.list(heifConverterPath, heifImage.getAbsolutePath(), resultFile.getAbsolutePath()),
                (int) Duration.standardMinutes(5).getMillis());
        logger.debug("Heif converter code {}, output {}", result.getCode(), result.getOutput());

        Check.isTrue(resultFile.getFile().length() != 0, "Couldn't convert heif file");
        return resultFile;
    }

    public static String getConvertedHeifImagePostfix() {
        return "_heif_result.jpg";
    }
}
