package ru.yandex.chemodan.uploader.preview;

import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.ExecUtils2;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.Check;

/**
 * @author metal
 */
public class LogoManager {
    @Value("${imagemagick.convert}")
    private String convertCmd;

    private File2 logoFile;

    public LogoManager(File2 logoFile) {
        if (EnvironmentType.getActive() != EnvironmentType.DEVELOPMENT
                && EnvironmentType.getActive() != EnvironmentType.TESTS)
        {
            Check.isTrue(logoFile.exists(), "Album logo file doesn't exist!");
        }
        this.logoFile = logoFile;
    }

    public void setLogoFile(File2 logoFile) {
        this.logoFile = logoFile;
    }

    public void createLogo(File2 resizedLogo, Dimension dimension) {
        ListF<String> cmd = Cf.list(convertCmd,
                logoFile.getAbsolutePath(), // source
                "-negate",
                "-resize", dimension.getWidth() + "x" + dimension.getHeight() + "!",
                resizedLogo.getAbsolutePath()); // result

        ExecUtils2.executeWithLogging(cmd);
    }

}
